/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
/**
 * \file    aic3106_test.c
 *
 * \brief   Routines to test the Audio Codec on Base EVM
 *
 * This file contains the routines for configuring and testing the AIC3106 Audio
 * codec on the Base Board.
 *
 * \author  0043
 *
 * \version 01a,19aug,2010 Created
 */

/*
 *====================
 * Includes
 *====================
 */
#include "dm388_i2c.h"
#include "aic3104.h"
#include "stdio.h"
 
/*
 *====================
 * Extern declarations
 *====================
 */

extern INT32 aic3104_MicHeadphone_Loop(UINT8    u8McaspNum);



/*
 *====================
 * Function implementations
 *====================
 */
/** **************************************************************************
 * \n \brief Routine to test the AIC3106 Audio codec on Base board
 *
 * This routine initializes the AIC3106 Audio Codec on the base board to test
 * various interfaces including the following
 *	(a) Playback on Head-phohne
 *  (b) Playback on Line-Out
 *  (c) Loopback the input on Microphone to head-set.
 *  (d) Loopback the input on Line-In to Line-Out
 *
 * \param u8McaspNum	[IN]	Instance of McASP number
 *
 * \return
 * \n      return SUCCESS for success  - Description
 * \n      return FAILED for error   - Description
 */
INT32 aic3104_tests
(
	UINT8    u8McaspNum
)
{	/* begin aic3106_tests */
	INT32 u32RetVal = SUCCESS;
	
	/* Initialize the I2C bus */

	u32RetVal = DM388I2cInit(AIC3104_I2C_BUS_NUM);
	
	if (SUCCESS != u32RetVal)
	{
		platform_write ("I2C initialization failed for bus number %d.\r\n", AIC3104_I2C_BUS_NUM);
		return FAILED;
	}
	platform_write("\n******************************\n\r");
	platform_write(  "    AIC3104 Audio Codec Test  \n\r");
	platform_write(  "******************************\n\r");

	platform_write("\nRunning Audio Line in Test\n");
#ifdef PRINTF
	platform_write (" Ensure the below setup is done :- \r\n");
	platform_write ("     (a) Headphone connected to the LINE OUT jack. \r\n");
	platform_write ("     (b) Audio Input connected to the LINE IN jack. \r\n");
#endif

	platform_write ("Verify that Audio supplied at LINE IN port is Coming to Headphone\r\n");

	//u32RetVal = aic3104_headphone_out(u8McaspNum);
	u32RetVal = aic3104_MicHeadphone_Loop (u8McaspNum);
	if (FAILED == u32RetVal)
	{
		platform_write (" Error occured during the configuraiton of AIC3104.\r\n");
		return (u32RetVal);
	}
	platform_write("Audio Line in Test Completed\n");
	platform_write("\nAIC3104 Audio Codec Test Completed!!\n");
	platform_write("-----------x----------");
	return (u32RetVal);
}	/* end aic3104_tests */
